<!DOCTYPE html>
<html lang="en"><head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <title>TEA кодер-декодер</title>
    <meta charset="utf-8">
    <meta name="author" content="Chris Veness, www.movable-type.co.uk">
    <meta name="keywords" content="кодер, декодер, кодировщик, декодировщик, безопасность, имейл">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="include/normalize.css">
    <link rel="stylesheet" href="include/prettify.css">
    <link rel="stylesheet" href="include/base.css">
    <link rel="stylesheet" href="include/stylesheet.css">
    <link rel="stylesheet" href="include/mtl.css">
    <style>
        pre { margin-left: 4em; max-width: 64em; padding: 1em; }
        pre.fullwidth { max-width: 72em; }
        pre.prettyprint { padding: 1em; } /* make general? */
        textarea { max-width: 36em; }
    </style>
    <script async="" src="include/analytics.js"></script><script src="include/es6-promise.js"></script><style>@media print {#ghostery-purple-box {display:none !important}}</style>
    <script src="include/fetch.js"></script>
    <script src="include/prettify.js">/* r224/r298 don't work! */</script>
    <script src="include/mtl.js">/* MTL utils */</script>
    <script src="include/tea-block.js"></script>
    <script type="text/javascript">
        'use strict';
        document.addEventListener('DOMContentLoaded', function(event) {
            document.querySelector('#password').oninput = function() {
                var password = document.querySelector('#password').value;
                var plaintxt = document.querySelector('#plaintxt').value;
                var t1 = performance.now();
                var encrtext = Tea.encrypt(plaintxt, password);
                var t2 = performance.now();
                document.querySelector('#encrtext').value = encrtext;
                document.querySelector('#time-encrypt').value = (t2-t1).toFixed(3)+'ms';
                document.querySelector('#encrtext').oninput(); // trigger decrypt
            };

            document.querySelector('#plaintxt').oninput = function() {
                var password = document.querySelector('#password').value;
                var plaintxt = document.querySelector('#plaintxt').value;
                var t1 = performance.now();
                var encrtext = Tea.encrypt(plaintxt, password);
                var t2 = performance.now();
                document.querySelector('#encrtext').value = encrtext;
                document.querySelector('#time-encrypt').value = (t2-t1).toFixed(3)+'ms';
                document.querySelector('#encrtext').oninput(); // trigger decrypt
            };

            document.querySelector('#encrtext').oninput = function() {
                try {
                    var password = document.querySelector('#password').value;
                    var encrtext = document.querySelector('#encrtext').value;
                  /*  var t1 = performance.now();*/
                    var decrtext = Tea.decrypt(encrtext, password);
                  /*  var t2 = performance.now();*/
                    document.querySelector('#decrtext').value = decrtext;
                  /*  document.querySelector('#time-decrypt').value = (t2-t1).toFixed(3)+'ms';*/
                } catch (e) {
                    document.querySelector('#decrtext').value = '';
                    document.querySelector('#time-decrypt').value = e.message;
                }
            };

            document.querySelector('#password').oninput(); // initial hash call

            // show source code
            fetch('//cdn.rawgit.com/chrisveness/crypto/bc59b37/tea-block.js')
                .then(function(response) {
                    return response.ok ? response.text() : response.status+' '+response.statusText;
                })
                .then(function(text) {
                    document.querySelector('#src-code').textContent = text;
                    prettyPrint();
                })
                .catch(function(error) { document.querySelector('#error').textContent = error.message; });
        });

        String.prototype.debug = function() {
            var s='';
            for (var i=0; i<this.length; i++) s += this.charAt(i) + ':' + this.charCodeAt(i) + ' ';
            return this + ': ' + s;
        }
    </script>
</head>

<body>
<div class="container">
<div class="row">
<h2 style="color:gray">TEA кодер/декодер </h2>
</div>
<div class="row">
<form name="f">
    <fieldset>
        <legend>Введите сначала ПАРОЛЬ, потом  ТЕКСТ или КОД </legend>
        <ul>

            <li>
                <label>ТЕКСТ <output class="small grey" id="text-encrypt">(кодировать)</output></label>
                <textarea name="plaintxt" id="plaintxt" class="width-full"></textarea>
            </li>
             <li>
                <label>ПАРОЛЬ</label>
                <input name="password" id="password" value="encryptioñ-pw" class="w12" type="text">
                <span class="small gray"> (может содержать любые символы любого языка)</span>
            </li>
            <li>
                <label> КОД <output class="small grey" id="text-encrypt">(декодировать)</output></label>
                <textarea name="encrtext" id="encrtext" class="width-full"></textarea>

            </li>
            <hr>
            <li style="background-color:#cef;padding:10px;border:none">
                <label>РЕЗУЛЬТАТ<br><output class="small grey" id="text-rezult"> (декодирования) </output></label>
                <textarea name="decrtext" id="decrtext" readonly="readonly" class="width-full"></textarea>

            </li>
        </ul>
    </fieldset>
</form>
 </div>
 <div class="row">
 <i>Пояснения как пользоваться.</i>
 <h6>Кодирование:</h6>
<ol>
  <li>Создайте пароль и вставьте его в поле ПАРОЛЬ</li>
  <li>Вставьте содержимое документа для кодирования в поле ТЕКСТ.</li>
  <li>Тщательно проверьте запоминаемость пароля. Измените его если нужно</li>
  <li> получите закодированный текст в поле КОД.</li>
  <li> сохраните код и пароль для декодирования на надежном носителе.</li>
  <li> Пошлите реципиенту код и пароль.Для повышенной надежности код и пароль посылайте разными каналами.</li>
</ol>
<h6>Декодирование</h6>
<ol>
  <li>Прежде всего найдите пароль и вставьте его в поле ПАРОЛЬ</li>
  <li>Вставьте код закодированного документа в поле КОД.</li>
  <li> получите декодированный текст документа в поле РЕЗУЛЬТАТ.</li>
</ol>


 </div>
<div class="row">
<footer class="small" style="margin-left:0;padding-left:10px;width:100%">
<img src="include/license-osi-mit.png" style="height:10px;width:auto; v-aligh:bottom"/>
 В данном вебсервисе использованы разработки/программы сообщества OpenSource, согласно лиценции MIT
</footer>
</div>

</body></html>
